/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!************************************************!*\
  !*** ./resources/js/admin/parts/translator.js ***!
  \************************************************/
(function () {
  "use strict";

  $('body').on('click', '.js-submit-translator', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var path = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar').prop('disabled', true);
    var $msg = $('.js-translate-msg');
    $msg.removeClass('text-danger').addClass('d-none text-success');
    $.post(path, data, function (result) {
      $msg.removeClass('d-none');
      if (result.error && result.error !== "null") {
        $msg.addClass('text-danger');
        $msg.text(result.error);
      } else {
        $msg.text(result.msg);
      }
      $this.removeClass('loadingbar').prop('disabled', false);
    }).fail(function (err) {
      $this.removeClass('loadingbar').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find(".js-ajax-".concat(key));
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
        $('html, body').animate({
          scrollTop: 5
        }, 600);
      }
    });
  });
  $('body').on('change', '#specificSwitch', function () {
    var $card = $('.js-specific-files-card');
    $card.addClass('d-none');
    $card.find('input').prop('checked', false);
    if (this.checked) {
      $card.removeClass('d-none');
    }
  });
})(jQuery);
/******/ })()
;