/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*******************************************************!*\
  !*** ./resources/js/design_1/panel/create_webinar.js ***!
  \*******************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  // =========
  // Actions
  // ======
  $('body').on('click', '#sendForReview', function (e) {
    $(this).addClass('loadingbar').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(0);
    $('#webinarForm').trigger('submit');
  });
  $('body').on('click', '#saveAsDraft', function (e) {
    $(this).addClass('loadingbar').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(1);
    $('#webinarForm').trigger('submit');
  });
  $('body').on('click', '#getNextStep', function (e) {
    $(this).addClass('loadingbar').prop('disabled', true);
    e.preventDefault();
    $('#forDraft').val(1);
    $('#getNext').val(1);
    $('#webinarForm').trigger('submit');
  });
  $('body').on('click', '.js-get-next-step', function (e) {
    e.preventDefault();
    if (!$(this).hasClass('active')) {
      $(this).addClass('loadingbar').prop('disabled', true);
      var step = $(this).attr('data-step');
      $('#getStep').val(step);
      $('#forDraft').val(1);
      $('#getNext').val(1);
      $('#webinarForm').trigger('submit');
    }
  });

  // =========
  // Category Filters
  // ======

  function handleGetFiltersTitleFromTranslations(translations, defaultLocale) {
    var title = null;
    if (Object.keys(translations).length) {
      Object.keys(translations).forEach(function (key) {
        var translation = translations[key];
        if (translation.locale === defaultLocale) {
          title = translation.title;
        }
      });
      if (!title) {
        title = translations[0].title;
      }
    }
    return title;
  }
  function handleFilterCardHtml(filterTitle, options) {
    var html = '';
    if (options.length) {
      html += "<div class=\"col-12 col-md-3 mt-16\">\n                        <div class=\"create-course-filter-card bg-white p-16 rounded-12 border-gray-200\">\n                            <h5 class=\"font-14 font-weight-bold mb-16\">".concat(filterTitle, "</h5>");
      Object.keys(options).forEach(function (index) {
        var option = options[index];
        var optionTitle = option.title;
        if (!optionTitle && option.translations) {
          optionTitle = handleGetFiltersTitleFromTranslations(option.translations, defaultLocale);
        }
        html += "<div class=\"custom-control custom-checkbox ".concat(index === 0 ? '' : 'mt-12', "\">\n                            <input type=\"checkbox\" name=\"filters[]\" value=\"").concat(option.id, "\" id=\"filterOptions").concat(option.id, "\" class=\"custom-control-input\">\n                            <label class=\"custom-control__label cursor-pointer\" for=\"filterOptions").concat(option.id, "\">").concat(optionTitle, "</label>\n                        </div>");
      });
      html += "</div>\n                    </div>";
    }
    return html;
  }
  function handleCategoryFilters(path) {
    var $categoriesFiltersContainer = $('#categoriesFiltersContainer');
    var $categoriesFiltersCard = $('#categoriesFiltersCard');
    var loadingHtml = "<div class=\"js-loading-card d-flex align-items-center justify-content-center w-100 my-40\">\n                    <img src=\"/assets/design_1/img/loading.svg\" width=\"56\" height=\"56\">\n                </div>";
    $categoriesFiltersContainer.removeClass('d-none');
    $categoriesFiltersCard.html(loadingHtml);
    $.get(path, function (result) {
      if (result && typeof result.filters !== "undefined" && result.filters.length) {
        var _defaultLocale = result.defaultLocale;
        var html = '';
        Object.keys(result.filters).forEach(function (key) {
          var filter = result.filters[key];
          var options = [];
          if (filter.options.length) {
            options = filter.options;
          }
          var filterTitle = filter.title;
          if (!filterTitle && filter.translations) {
            filterTitle = handleGetFiltersTitleFromTranslations(filter.translations, _defaultLocale);
          }
          html += handleFilterCardHtml(filterTitle, options);
        });
        $categoriesFiltersCard.html(html);
      } else {
        $categoriesFiltersContainer.addClass('d-none');
        $categoriesFiltersCard.html('');
      }
    });
  }
  $('body').on('change', '#categories', function (e) {
    e.preventDefault();
    var category_id = this.value;
    var path = "/panel/filters/get-by-category-id/".concat(category_id);
    handleCategoryFilters(path);
  });
  $('body').on('change', '#productCategories', function (e) {
    e.preventDefault();
    var category_id = this.value;
    var path = "/panel/store/products/filters/get-by-category-id/".concat(category_id);
    handleCategoryFilters(path);
  });

  // Options

  $('body').on('change', '#partnerInstructorSwitch', function (e) {
    var isChecked = this.checked;
    if (isChecked) {
      $('#partnerInstructorInput').removeClass('d-none');
    } else {
      $('#partnerInstructorInput').addClass('d-none');
    }
  });
  $('body').on('click', '.js-save-price_plan', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.js-price_plan-form');
    handleSendRequestItemForm(form, $this);
  });

  // =========
  // Chapters
  // ======

  $('body').on('click', '.js-add-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var chapterId = $this.attr("data-chapter");
    var webinarId = $this.attr('data-webinar-id');
    var path = "/panel/chapters/get-form";
    var modalTitle = newChapterLang;
    if (typeof chapterId !== "undefined" && chapterId) {
      path = "/panel/chapters/".concat(chapterId, "/edit");
      modalTitle = editChapterLang;
    }
    handleBasicModal(path, modalTitle, function (result, $body, $footer) {
      $body.find('.js-chapter-webinar-id').val(webinarId);
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-save-chapter btn btn-sm btn-primary\">".concat(saveLang, "</a>\n                <button type=\"button\" class=\"close-swl btn btn-sm btn-danger ml-8\">").concat(closeLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '40rem');
  });
  $('body').on('click', '.js-save-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-custom-modal').find('.js-content-form');
    handleSendRequestItemForm($form, $this);
  });
  $('body').on('click', '.js-change-content-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr('data-item-id');
    var itemType = $this.attr('data-item-type');
    var chapterId = $this.attr('data-chapter-id');
    var random = randomString();
    var html = $('#changeChapterModalHtml').html();
    html = html.replace(/record/g, random);
    var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-save-change-chapter btn btn-sm btn-primary\">".concat(saveLang, "</a>\n                <button type=\"button\" class=\"close-swl btn btn-sm btn-danger ml-8\">").concat(closeLang, "</button>\n            </div>");
    Swal.fire({
      html: makeModalHtml(changeChapterLang, closeIcon, html, footerHtml),
      showCancelButton: false,
      showConfirmButton: false,
      width: '40rem',
      didOpen: function didOpen() {
        var $body = $('.js-custom-modal');
        var $footer = $('.custom-modal-footer');
        $body.find(".js-item-id").val(itemId);
        $body.find(".js-item-type").val(itemType);
        $body.find('.js-ajax-chapter_id').val(chapterId).change();
      }
    });
  });
  $('body').on('click', '.js-save-change-chapter', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-custom-modal').find('.change-chapter-form');
    handleSendRequestItemForm($form, $this);
  });
  $('body').on('click', '.js-add-course-content-btn, .add-new-interactive-file-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var type = $this.attr('data-type');
    var chapterId = $this.attr('data-chapter');
    var appendTargetElId = $this.attr('data-target-el-id');
    var contentTagId = '#chapterContentAccordion' + chapterId;
    if (typeof appendTargetElId !== "undefined" && appendTargetElId) {
      contentTagId = "#".concat(appendTargetElId);
    }
    var key = randomString();
    var $body = null;
    switch (type) {
      case 'file':
        $body = $('#newFileForm');
        break;
      case 'new_interactive_file':
        $body = $('#newInteractiveFileForm');
        break;
      case 'session':
        $body = $('#newSessionForm');
        break;
      case 'text_lesson':
        $body = $('#newTextLessonForm');
        break;
      case 'assignment':
        $body = $('#newAssignmentForm');
        break;
      case 'quiz':
        $body = $('#newQuizForm');
        break;
    }
    if ($body) {
      $body.find('.chapter-input').val(chapterId);
      var html = $body.html();
      html = html.replace(/record/g, key);
      if (type === "text_lesson") {
        html = html.replaceAll('attachments-select2', 'attachments-select2-' + key);
        html = html.replaceAll('js-content-summernote-input', 'js-content-summernote-' + key);
        html = html.replaceAll('js-hidden-content-summernote', 'js-hidden-content-summernote-' + key);
      }
      var $contentTagId = $(contentTagId);
      $contentTagId.prepend(html);
      if (type === "text_lesson") {
        $('.attachments-select2-' + key).select2({
          multiple: true,
          width: '100%'
        });
        if (jQuery().summernote) {
          makeSummernote($('.js-content-summernote-' + key), 400, function (contents, $editable) {
            $('.js-hidden-content-summernote-' + key).val(contents);
          });
        }
      }
      var $selectItems = $contentTagId.find('.js-make-select2-item');
      if ($selectItems.length) {
        var _iterator = _createForOfIteratorHelper($selectItems),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var selectItem = _step.value;
            handleSelect2($(selectItem));
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      resetDatePickers();
    }
  });
  $('body').on('change', '.js-api-input', function (e) {
    e.preventDefault();
    var sessionForm = $(this).closest('.session-form');
    var value = this.value;
    sessionForm.find('.js-zoom-not-complete-alert').addClass('d-none');
    sessionForm.find('.js-agora-chat-and-rec').addClass('d-none');
    if (value === 'big_blue_button') {
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-api-secret').removeClass('d-none');
      sessionForm.find('.js-moderator-secret').removeClass('d-none');
    } else if (value === 'zoom') {
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-api-secret').addClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
      if (hasZoomApiToken && hasZoomApiToken !== 'true') {
        sessionForm.find('.js-zoom-not-complete-alert').removeClass('d-none');
      }
    } else if (value === 'agora') {
      sessionForm.find('.js-agora-chat-and-rec').removeClass('d-none');
      sessionForm.find('.js-api-secret').addClass('d-none');
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
    } else if (value === 'jitsi') {
      sessionForm.find('.js-local-link').addClass('d-none');
      sessionForm.find('.js-api-secret').addClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
    } else {
      sessionForm.find('.js-local-link').removeClass('d-none');
      sessionForm.find('.js-api-secret').removeClass('d-none');
      sessionForm.find('.js-moderator-secret').addClass('d-none');
    }
  });
  $('body').on('change', '.js-sequence-content-switch', function () {
    var parent = $(this).closest('.accordion');
    var sequenceContentInputs = parent.find('.js-sequence-content-inputs');
    sequenceContentInputs.addClass('d-none');
    if (this.checked) {
      sequenceContentInputs.removeClass('d-none');
    }
  });
  $('body').on('click', '.js-save-course-content', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-content-form');
    handleSendRequestItemForm($form, $this);
  });

  // =========
  // Files
  // ======

  function handleShowFileInputsBySource($form, source, fileType) {
    var $fileTypeVolumeInputs = $form.find('.js-file-type-volume');
    var $volumeInputs = $form.find('.js-file-volume-field');
    var $typeInputs = $form.find('.js-file-type-field');
    var $downloadableInput = $form.find('.js-downloadable-input');
    var $onlineViewerInput = $form.find('.js-online_viewer-input');
    var $fileUrlInputCard = $form.find('.js-file-url-input');
    var $fileUploadInputCard = $form.find('.js-file-upload-input');
    var $fileUploadInputField = $fileUploadInputCard.find('input');
    var $secureHostUploadTypeField = $form.find('.js-secure-host-upload-type-field');
    $fileUrlInputCard.removeClass('d-none');
    $fileUploadInputCard.addClass('d-none');
    $volumeInputs.addClass('d-none');
    $typeInputs.removeClass('d-none'); // parent is hidden or visible
    $secureHostUploadTypeField.addClass('d-none');
    $fileUploadInputField.find('input').removeAttr("accept");
    switch (source) {
      case 'youtube':
      case 'vimeo':
      case 'iframe':
        $fileTypeVolumeInputs.addClass('d-none');
        $fileTypeVolumeInputs.find('select').val('');
        $downloadableInput.find('input').prop('checked', false);
        $downloadableInput.addClass('d-none');
        $onlineViewerInput.find('input').prop('checked', false);
        $onlineViewerInput.addClass('d-none');
        break;
      case 'external_link':
      case 's3':
        $fileTypeVolumeInputs.removeClass('d-none');
        if (fileType && fileType === 'video') {
          $downloadableInput.removeClass('d-none');
        } else {
          $downloadableInput.find('input').prop('checked', false);
          $downloadableInput.addClass('d-none');
        }
        if (source === 'external_link') {
          $volumeInputs.removeClass('d-none');
        } else if (source === 's3') {
          $fileUrlInputCard.addClass('d-none');
          $fileUploadInputCard.removeClass('d-none');
        }
        if (fileType && fileType === 'pdf') {
          $onlineViewerInput.removeClass('d-none');
        } else {
          $onlineViewerInput.find('input').prop('checked', false);
          $onlineViewerInput.addClass('d-none');
        }
        break;
      case 'secure_host':
        $fileTypeVolumeInputs.addClass('d-none');
        $fileTypeVolumeInputs.find('select').val('');
        $fileUrlInputCard.addClass('d-none');
        $fileUploadInputCard.removeClass('d-none');
        $downloadableInput.find('input').prop('checked', false);
        $downloadableInput.addClass('d-none');
        $onlineViewerInput.addClass('d-none');
        $secureHostUploadTypeField.removeClass('d-none');
        $fileUploadInputField.find('input').attr('accept', "video/mp4,video/x-m4v,video/*");
        break;
      case 'google_drive':
        $fileTypeVolumeInputs.removeClass('d-none');
        $volumeInputs.removeClass('d-none');
        $downloadableInput.find('input').prop('checked', false);
        $downloadableInput.addClass('d-none');
        if (fileType && fileType === 'pdf') {
          $onlineViewerInput.removeClass('d-none');
        } else {
          $onlineViewerInput.find('input').prop('checked', false);
          $onlineViewerInput.addClass('d-none');
        }
        break;
      case 'upload':
        $fileTypeVolumeInputs.removeClass('d-none');
        $downloadableInput.removeClass('d-none');
        if (fileType && fileType === 'pdf') {
          $onlineViewerInput.removeClass('d-none');
        } else {
          $onlineViewerInput.find('input').prop('checked', false);
          $onlineViewerInput.addClass('d-none');
        }
        $fileUrlInputCard.addClass('d-none');
        $fileUploadInputCard.removeClass('d-none');
        break;
    }
    if (fileType && (fileType === 'image' || fileType === 'document' || fileType === 'powerpoint' || fileType === 'sound' || fileType === 'archive' || fileType === 'project')) {
      $downloadableInput.find('input').prop('checked', true);
      $downloadableInput.addClass('d-none');
    }
    if (filePathPlaceHolderBySource) {
      $fileUrlInputCard.find('input').attr('placeholder', filePathPlaceHolderBySource[source]);
    }
  }
  function handleSecureHostUploadType($form, value) {
    var isOnChangeByUser = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var $fileUrlInputCard = $form.find('.js-file-url-input');
    var $fileUploadInputCard = $form.find('.js-file-upload-input');
    var $fileTypeVolumeInputs = $form.find('.js-file-type-volume');
    var $volumeInputs = $form.find('.js-file-volume-field');
    var $typeInputs = $form.find('.js-file-type-field');
    if (isOnChangeByUser) {
      $typeInputs.addClass('d-none');
    }
    if (value === "manual") {
      if (isOnChangeByUser) {
        $fileTypeVolumeInputs.removeClass('d-none');
        $volumeInputs.removeClass('d-none');
      }
      $fileUrlInputCard.removeClass('d-none');
      $fileUploadInputCard.addClass('d-none');
    } else {
      if (isOnChangeByUser) {
        $fileTypeVolumeInputs.addClass('d-none');
        $volumeInputs.addClass('d-none');
      }
      $fileUrlInputCard.addClass('d-none');
      $fileUploadInputCard.removeClass('d-none');
    }
  }
  $('body').on('change', '.js-file-storage', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var formGroup = $(this).closest('.file-form');
    var fileType = formGroup.find('.js-ajax-file_type').val();
    handleShowFileInputsBySource(formGroup, value, fileType);
  });
  $('body').on('change', '.js-ajax-file_type', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var formGroup = $(this).closest('.file-form');
    var source = formGroup.find('.js-file-storage').val();
    handleShowFileInputsBySource(formGroup, source, value);
  });
  $('body').on('change', '.js-secure-host-upload-type-field input', function (e) {
    e.preventDefault();
    var value = $(this).val();
    var $form = $(this).closest('.file-form');
    handleSecureHostUploadType($form, value, true);
  });
  $(document).ready(function () {
    var $fileForms = $('.file-form');
    if ($fileForms && $fileForms.length) {
      $fileForms.each(function (key) {
        if ($fileForms[key]) {
          var $form = $($fileForms[key]);
          var source = $form.find('.js-file-storage').val();
          var fileType = $form.find('.js-ajax-file_type').val();
          handleShowFileInputsBySource($form, source, fileType);
          var secureHostType = $form.find('.js-secure-host-upload-type-field input:checked').val();
          if (secureHostType) {
            handleSecureHostUploadType($form, secureHostType);
          }
        }
      });
    }
    var summernoteTarget = $('.accordion .js-content-summernote');
    if (summernoteTarget.length) {
      var _iterator2 = _createForOfIteratorHelper(summernoteTarget),
        _step2;
      try {
        var _loop = function _loop() {
          var summernoteTargetElement = _step2.value;
          var $summernoteTargetEl = $(summernoteTargetElement);
          makeSummernote($summernoteTargetEl, 400, function (contents, $editable) {
            $summernoteTargetEl.parent().find('.js-hidden-content-summernote').val(contents);
          });
        };
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  });
  $('body').on('change', '.js-interactive-type', function () {
    var fileForm = $(this).closest('.file-form');
    var $fileName = fileForm.find('.js-interactive-file-name-input');
    $fileName.addClass('d-none');
    if ($(this).val() === 'custom') {
      $fileName.removeClass('d-none');
    }
  });
  $('body').on('click', '.js-assignment-attachments-add-btn', function (e) {
    e.preventDefault();
    var $container = $(this).closest('.js-assignment-attachments').find(".js-assignment-attachments-items");
    var inputKey = $(this).attr("data-input-key");
    var randomKey = randomString();
    var html = "<div class=\"js-ajax-attachments position-relative mt-12\">\n                    <div class=\"p-16 border-gray-200 rounded-8\">\n                        <div class=\"row\">\n                            <div class=\"col-12 col-lg-6\">\n                                <div class=\"form-group mb-0\">\n                                    <label class=\"form-group-label bg-white\">".concat(titleLang, "</label>\n                                    <input type=\"text\" name=\"ajax[").concat(inputKey, "][attachments][").concat(randomKey, "][title]\" class=\"form-control bg-white\" placeholder=\"\"/>\n                                </div>\n                            </div>\n\n                            <div class=\"col-12 col-lg-6 mt-20 mt-lg-0\">\n                                <div class=\"form-group mb-0\">\n                                    <label class=\"form-group-label bg-white\">").concat(chooseFileLang, "</label>\n\n                                    <div class=\"custom-file bg-white\">\n                                        <input type=\"file\" name=\"ajax[").concat(inputKey, "][attachments][").concat(randomKey, "][attach]\" class=\"js-ajax-upload-file-input js-ajax-file_upload custom-file-input\" data-upload-name=\"ajax[").concat(inputKey, "][attachments][").concat(randomKey, "][attach]\" id=\"attachments_assignment_").concat(randomKey, "\">\n                                        <span class=\"custom-file-text\"></span>\n                                        <label class=\"custom-file-label\" for=\"attachments_assignment_").concat(randomKey, "\">").concat(browseLang, "</label>\n                                    </div>\n\n                                    <div class=\"invalid-feedback d-block\"></div>\n                                </div>\n                            </div>\n                        </div>\n\n                        <div class=\"d-flex justify-content-end mt-16\">\n                            <div class=\"js-assignment-attachments-remove-btn btn btn-danger btn-lg\">").concat(deleteLang, "</div>\n                        </div>\n                    </div>\n                </div>");
    $container.append(html);
  });
  $('body').on('click', '.js-assignment-attachments-remove-btn', function (e) {
    e.preventDefault();
    $(this).closest('.js-ajax-attachments').remove();
  });
})(jQuery);
/******/ })()
;