/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**********************************************************!*\
  !*** ./resources/js/design_1/panel/store_my_purchase.js ***!
  \**********************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-view-tracking-code', function () {
    var $this = $(this);
    var saleId = $this.attr('data-sale-id');
    var orderId = $this.attr('data-product-order-id');
    var path = "/panel/store/purchases/".concat(saleId, "/getProductOrder/").concat(orderId);
    $.get(path, function (result) {
      if (result && result.order) {
        var html = "\n                    <div>\n                        <div class=\"section-title\">\n                            <h3 class=\"section-title__heading font-20 text-dark mb-24\">".concat(viewTrackingCodeModalTitleLang, "</h3>\n                        </div>\n\n                        <div class=\"mt-16 w-100\">\n                            <div class=\"\">\n                                <span class=\"font-weight-500 mr-4\">").concat(trackingCodeLang, " :</span>\n                                <span class=\"font-14 text-gray-500\">").concat(result.order.tracking_code, "</span>\n                            </div>\n\n                            <div class=\"mt-16\">\n                                <span class=\"font-weight-500 mr-4\">").concat(addressLang, " :</span>\n                                <span class=\"font-14 text-gray-500\">").concat(result.order.address, "</span>\n                            </div>\n                        </div>\n\n                        <div class=\"mt-32 d-flex align-items-center justify-content-end\">\n                            ").concat(result.shipping_tracking_url && result.shipping_tracking_url !== '' && result.shipping_tracking_url !== 'null' ? "\n                                            <div class=\"mr-20\">\n                                                <a href=\"".concat(result.shipping_tracking_url, "\" class=\"btn btn-primary btn-sm\">").concat(shippingTrackingUrlLang, "</a>\n                                            </div>\n                                           ") : '', "\n\n                            <button type=\"button\" class=\"btn btn-danger btn-sm close-swl\">").concat(closeLang, "</button>\n                        </div>\n                    </div>\n                ");
        Swal.fire({
          html: html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '40rem'
        });
      }
    });
  });
  $('body').on('click', '.js-got-the-parcel', function () {
    var $this = $(this);
    var saleId = $this.attr('data-sale-id');
    var orderId = $this.attr('data-product-order-id');
    var path = "/panel/store/purchases/".concat(saleId, "/productOrder/").concat(orderId, "/setGotTheParcel");
    var html = "\n                    <div class=\"p-16\">\n                        <div class=\"section-title\">\n                            <h3 class=\"section-title__heading font-20 text-dark mb-24\">".concat(gotTheParcelLang, "</h3>\n                        </div>\n\n                        <div class=\"mt-16 w-100\">\n                            <p class=\"\">").concat(gotTheParcelConfirmTextLang, "</p>\n                        </div>\n\n                        <div class=\"mt-32 d-flex align-items-center justify-content-end\">\n                            <button type=\"button\" id=\"saveGotTheParcel\" data-action=\"").concat(path, "\" class=\"btn btn-sm btn-primary\">").concat(confirmLang, "</button>\n                            <button type=\"button\" class=\"btn btn-danger btn-sm close-swl ml-8\">").concat(closeLang, "</button>\n                        </div>\n                    </div>\n                ");
    Swal.fire({
      html: html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '32rem'
    });
  });
  $('body').on('click', '#saveGotTheParcel', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $.get(path, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark py-24">' + gotTheParcelSaveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      } else {
        Swal.fire({
          icon: 'error',
          html: '<h3 class="font-20 text-center text-dark py-24">' + gotTheParcelSaveErrorLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
      }
    });
  });
})(jQuery);
/******/ })()
;