/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*************************************************!*\
  !*** ./resources/js/design_1/parts/comments.js ***!
  \*************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-submit-comment-btn, .js-submit-comment-reply-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var path = $form.attr('action');
    handleSendRequestItemForm($form, $this, path);
  });
  $('body').on('click', '.js-reply-comment', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr("data-item");
    var itemName = $this.attr("data-item-name");
    var commentId = $this.attr("data-comment");
    var $html = $(".js-reply-to-comment-html").html();
    var $parent = $this.closest(".js-comment-card");
    var $replyContainer = $parent.find(".js-comment-reply-form");
    $replyContainer.html($html);
    var formPath = "/comments/".concat(commentId, "/reply");
    var $form = $replyContainer.find('form');
    $form.attr("action", formPath);
    $form.find('input[name="item_id"]').val(itemId);
    $form.find('input[name="item_name"]').val(itemName);
    $('html, body').animate({
      scrollTop: $replyContainer.offset().top - 150
    }, 1000);
  });
  $('body').on('click', '.js-close-comment-reply-btn', function (e) {
    e.preventDefault();
    $(this).closest(".js-comment-reply-form").html("");
  });
  var commentsLoadMore = {
    page: 1
  };
  $('body').on('click', '.js-comments-load-more-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr("data-path");
    $this.addClass("loadingbar gray").prop('disabled', true);
    var $container = $('.js-course-comments-container');
    var page = commentsLoadMore.page + 1;
    commentsLoadMore = {
      page: page
    };
    $.post(path, commentsLoadMore, function (result) {
      if (result.code === 200) {
        $container.append(result.html);
        if (!result.has_more) {
          $this.parent().remove();
        }
      }
    }).always(function () {
      $this.removeClass("loadingbar gray").prop('disabled', false);
    });
  });

  /********
   * Report
   * */

  $('body').on('click', '.js-report-comment', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr("data-item");
    var itemName = $this.attr("data-item-name");
    var commentId = $this.attr("data-comment");
    var path = "/comments/get-report-modal?comment=".concat(commentId, "&item=").concat(itemId, "&type=").concat(itemName);
    handleBasicModal(path, reportCommentLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-submit-comment-report btn btn-primary\">".concat(reportLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '40rem');
  });
  $('body').on('click', '.js-submit-comment-report', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-custom-modal').find('.js-comment-report-form');
    var path = $form.attr("data-action");
    handleSendRequestItemForm($form, $this, path);
  });
})(jQuery);
/******/ })()
;