/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*******************************************************!*\
  !*** ./resources/js/design_1/parts/content_delete.js ***!
  \*******************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-content-delete-action', function (e) {
    e.preventDefault();
    e.stopPropagation();
    var $this = $(this);
    var href = $this.attr('href');
    var itemId = $this.attr('data-item');
    var itemType = $this.attr('data-item-type');
    var bodyHtml = "\n                <div class=\"d-flex-center flex-column text-center pt-32\">\n                    <div class=\"d-flex-center size-72 rounded-16 bg-gray\">\n                        <div class=\"d-flex-center size-64 rounded-16 bg-danger\">".concat(bulDangerIcon, "</div>\n                    </div>\n\n                    <h4 class=\"font-14 text-dark mt-8\">").concat(deleteRequestTitleLang, "</h4>\n                </div>\n\n                <div class=\"mt-16 p-12 rounded-12 border-gray-200 font-12 text-gray-500\">").concat(deleteRequestDescriptionLang, "</div>\n\n                <div class=\"js-delete-content-form mt-24\" data-action=\"/panel/content-delete-request\">\n                    <input type=\"hidden\" name=\"item_id\" value=\"").concat(itemId, "\">\n                    <input type=\"hidden\" name=\"item_type\" value=\"").concat(itemType, "\">\n\n                    <div class=\"form-group\">\n                        <label class=\"form-group-label bg-white\">").concat(requestDetailsLang, "</label>\n                        <textarea name=\"description\" class=\"js-ajax-description form-control bg-white\" rows=\"5\"></textarea>\n                        <div class=\"invalid-feedback font-14\"></div>\n                    </div>\n                </div>");
    var $footerHtml = "<div class=\"d-flex align-items-center gap-24 justify-content-end\">\n                <button type=\"button\" class=\"close-swl btn btn-transparent\">".concat(deleteAlertCancel, "</button>\n                <button type=\"button\" class=\"js-send-delete-request btn btn-danger\">").concat(sendRequestLang, "</button>\n            </div>");
    var html = makeModalHtml(deleteRequestLang, closeIcon, bodyHtml, $footerHtml);
    Swal.fire({
      html: html,
      showCancelButton: false,
      showConfirmButton: false,
      customClass: {
        content: 'p-0 text-left'
      },
      width: '37rem'
    });
  });
  $('body').on('click', '.js-send-delete-request', function (e) {
    e.preventDefault();
    var $this = $(this);
    var form = $this.closest('.js-custom-modal').find('.js-delete-content-form');
    var data = serializeObjectByTag(form);
    var action = form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          title: result.title,
          html: '<p class="font-16 text-center text-gray">' + result.msg + '</p>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 1500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;