/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*************************************************************!*\
  !*** ./resources/js/design_1/parts/video_player_helpers.js ***!
  \*************************************************************/
(function ($) {
  "use strict";

  var fileVideoPlayer;
  window.convertVimeoLinkToPlay = function (path) {
    path = path.trim();
    if (path.includes('player.vimeo.com/video')) return path;
    if (!/^https?:\/\//i.test(path)) path = 'https://' + path;
    try {
      var url = new URL(path);
      if (url.hostname.replace(/^www\./, '') === 'vimeo.com') {
        var id = url.pathname.split('/').filter(Boolean).pop();
        if (/^\d+$/.test(id)) return "https://player.vimeo.com/video/".concat(id);
      }
    } catch (_unused) {}
    return path;
  };
  window.makeVideoPlayerHtml = function (path, storage, height, tagId) {
    var thumbnail = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;
    var html = '';
    var options = {
      autoplay: false,
      preload: 'auto',
      previewThumbnails: {
        enabled: !!thumbnail,
        src: thumbnail !== null && thumbnail !== void 0 ? thumbnail : ''
      }
    };
    if (storage === 'youtube') {
      html = "<div class=\"plyr__video-embed w-100 h-100\" id=\"".concat(tagId, "\" data-poster=\"").concat(thumbnail !== null && thumbnail !== void 0 ? thumbnail : '', "\">\n              <iframe\n                src=\"").concat(path, "?origin=").concat(siteDomain, "&amp;iv_load_policy=3&amp;modestbranding=1&amp;playsinline=1&amp;showinfo=0&amp;rel=0&amp;enablejsapi=0&amp;controls=0\"\n                allowfullscreen\n                allowtransparency\n                allow=\"autoplay\"\n                class=\"img-cover rounded-16\"\n                data-poster=\"").concat(thumbnail !== null && thumbnail !== void 0 ? thumbnail : '', "\"\n              ></iframe>\n            </div>");
      // Tighten Plyr options for YouTube
      options.clickToPlay = false;
      options.disableContextMenu = true;
      options.youtube = {
        rel: 0,
        modestbranding: 1,
        iv_load_policy: 3,
        fs: 0,
        disablekb: 1,
        playsinline: 1,
        controls: 0
      };
    } else if (storage === "vimeo") {
      var vimeoPath = convertVimeoLinkToPlay(path);
      html = "<div class=\"plyr__video-embed w-100 h-100\" id=\"".concat(tagId, "\" data-poster=\"").concat(thumbnail !== null && thumbnail !== void 0 ? thumbnail : '', "\">\n              <iframe\n                src=\"").concat(vimeoPath, "?loop=false&amp;byline=false&amp;portrait=false&amp;title=false&amp;speed=true&amp;transparent=0&amp;gesture=media\"\n                allowfullscreen\n                allowtransparency\n                allow=\"autoplay\"\n                class=\"img-cover rounded-16\"\n                data-poster=\"").concat(thumbnail !== null && thumbnail !== void 0 ? thumbnail : '', "\"\n              ></iframe>\n            </div>");
    } else if (storage === "secure_host") {
      html = '<iframe src="' + path + '" class="img-cover bg-gray-200" frameborder="0" allowfullscreen="true" ></iframe>';
    } else {
      html = "<video id=\"".concat(tagId, "\" class=\"plyr-io-video\" controls preload=\"auto\" width=\"100%\" height=\"").concat(height, "\" data-poster=\"").concat(thumbnail !== null && thumbnail !== void 0 ? thumbnail : '', "\">\n                <source src=\"").concat(path, "\" type=\"video/mp4\"/>\n            </video>");
    }
    return {
      html: html,
      options: options
    };
  };
  window.handleVideoByFileId = function (fileId, $contentEl, callback) {
    closeVideoPlayer();
    var height = $(window).width() > 991 ? 426 : 264;
    $.post('/course/getFilePath', {
      file_id: fileId
    }, function (result) {
      if (result && result.code === 200) {
        var storage = result.storage;
        var videoTagId = 'videoPlayer' + fileId;
        var _makeVideoPlayerHtml = makeVideoPlayerHtml(result.path, storage, height, videoTagId),
          html = _makeVideoPlayerHtml.html,
          options = _makeVideoPlayerHtml.options;
        if ($contentEl) {
          $contentEl.html(html);
        }
        if (storage !== "secure_host") {
          fileVideoPlayer = new Plyr("#".concat(videoTagId), options);
        }
        callback();
      } else {
        showToast("error", notAccessToastTitleLang, notAccessToastMsgLang);
      }
    }).fail(function (err) {
      showToast("error", notAccessToastTitleLang, notAccessToastMsgLang);
    });
  };
  window.closeVideoPlayer = function () {
    if (fileVideoPlayer !== undefined) {
      fileVideoPlayer.stop();
    }
  };
  window.pauseVideoPlayer = function () {
    if (fileVideoPlayer !== undefined) {
      fileVideoPlayer.pause();
    }
  };
})(jQuery);
/******/ })()
;