/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*************************************************************!*\
  !*** ./resources/js/design_1/landing_builder/components.js ***!
  \*************************************************************/
(function ($) {
  "use strict";

  $(document).ready(function () {
    var select2Els = $('.js-make-select2');
    if (select2Els && select2Els.length) {
      handleSelect2(select2Els);
    }
    var $iconsSelect2 = $('.js-icons-select2');
    if ($iconsSelect2.length) {
      handleChooseIconSelect2($iconsSelect2);
    }
  });
  function formatIcon(icon) {
    if (icon && icon.selected) {
      var $element = $(icon.element);
      icon.svg = $element.attr('data-svg');
    } else if (!icon || typeof icon.id === "undefined") {
      return "";
    } else if (icon.id === "" && icon.text) {
      return icon.text;
    }
    return $("<div class=\"d-flex align-items-center gap-8\">\n                    ".concat(icon.svg, "\n                    <span class=\"\">").concat(icon.text, "</span>\n                </div>"));
  }
  function handleChooseIconSelect2($iconsSelect2) {
    if ($iconsSelect2.length) {
      $iconsSelect2.select2({
        templateResult: formatIcon,
        templateSelection: formatIcon,
        allowClear: true,
        width: '100%',
        minimumInputLength: 3,
        ajax: {
          url: "/iconsax/search",
          dataType: 'json',
          type: "POST",
          quietMillis: 50,
          data: function data(params) {
            return {
              name: params.term
            };
          },
          processResults: function processResults(data) {
            return {
              results: data.results
            };
          }
        }
      });
    }
  }
  function handleSearchableSelects() {
    var $parent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var searchableSelect;
    var select2Els;
    if ($parent) {
      searchableSelect = $parent.find('.js-searchable-select');
      select2Els = $parent.find('.js-make-select2-item');
      var $iconsSelect2 = $parent.find('.js-make-icons-select2');
      if ($iconsSelect2.length) {
        handleChooseIconSelect2($iconsSelect2);
      }
    } else {
      searchableSelect = $('.js-searchable-select');
    }
    if (select2Els && select2Els.length) {
      handleSelect2(select2Els);
    }
    if (searchableSelect && searchableSelect.length) {
      handleSearchableSelect(searchableSelect);
    }
  }
  $('body').on('click', '.js-add-component-to-landing', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $assignedComponents = $('.js-assigned-components-lists');
    var $assignedComponentsLoading = $('.js-assigned-components-lists-loading');
    var $assignedComponentsNoItems = $('.js-assigned-components-lists-no-items');
    $assignedComponentsLoading.removeClass('d-none');
    var componentId = $this.attr('data-item');
    var landingId = $this.attr('data-landing');
    var path = "".concat(landingBuilderPrefixUrl, "/").concat(landingId, "/components/add");
    var data = {
      component_id: componentId
    };
    $.post(path, data, function (result) {
      if (result.code === 200) {
        $assignedComponentsNoItems.remove();
        $assignedComponents.append(result.html);
      }
      $assignedComponentsLoading.addClass('d-none');
      showToast('success', result.title, result.msg);
    }).fail(function (err) {
      showToast('error', oopsLang, somethingWentWrongLang);
      $assignedComponentsLoading.addClass('d-none');
    });
  });

  // Addable Items
  $('body').on('click', '.js-addable-items-add-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $parent = $this.closest('.js-addable-items');
    var $itemsCard = $parent.find('.js-addable-items-lists');
    var name = $parent.attr('data-name');
    var label = $parent.attr('data-label');
    var placeholder = $parent.attr('data-placeholder');
    name = name.replaceAll('record', randomString());
    name = name.replaceAll('nabat', randomString());
    var clone = $parent.find('.js-addable-main-row').clone();
    var html = clone.prop('innerHTML');
    html = html.replaceAll('__l', label);
    html = html.replaceAll('__n', name);
    html = html.replaceAll('__p', placeholder);
    html = html.replaceAll('__i', closeIcon);
    $itemsCard.append(html);
  });
  $('body').on('click', '.js-addable-items-remove-btn', function (e) {
    e.preventDefault();
    $(this).closest('.js-addable-item-card').remove();
  });
  // End Addable Items

  $('body').on('change', '.js-select-change-for-action', function (e) {
    e.preventDefault();
    var $this = $(this);
    var value = $this.val();
    var elClass = $this.attr('data-change-action');
    var parentClass = $this.attr('data-change-parent');
    if (elClass) {
      var $parent = $('body');
      if (parentClass) {
        $parent = $this.closest(".".concat(parentClass));
      }
      var $fields = $parent.find(".".concat(elClass));
      var $field = $parent.find(".js-select-change-for-action-field-".concat(value));
      $fields.addClass('d-none');
      $fields.find('input').val('');
      $field.removeClass('d-none');
    }
  });

  // Addable Accordions
  $('body').on('click', '.js-addable-accordions-add-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var mainRow = $this.attr('data-main-row');
    var $parent = $this.closest('.js-addable-accordions');
    var $itemsCard = $parent.find('.js-addable-accordions-lists');
    if (mainRow) {
      var randomStr = randomString();
      var $mainRow = $(".".concat(mainRow));
      var clone = $mainRow.clone();
      var html = clone.prop('innerHTML');
      html = html.replaceAll('record', randomStr);
      $itemsCard.append("<div class=\"js-addable-accordion-".concat(randomStr, "\">").concat(html, "</div>"));
      handleSearchableSelects($(".js-addable-accordion-".concat(randomStr)));
      handleAccordionCollapse();
    }
  });
  $('body').on('click', '.js-addable-accordion-remove-btn', function (e) {
    e.preventDefault();
    $(this).closest('.accordion').remove();
  });

  // Video Content
  $('body').on('change', '.js-video-source-select', function (e) {
    e.preventDefault();
    var $this = $(this);
    var value = $this.val();
    var parent = $this.closest('.js-video-sources-parent');
    var $onlines = parent.find('.js-video-sources-online-field');
    var $uploads = parent.find('.js-video-sources-upload-field');
    if ($.inArray(value, ['youtube', 'vimeo', 'external', 'iframe']) !== -1) {
      $onlines.removeClass('d-none');
      $uploads.addClass('d-none');
    } else {
      $onlines.addClass('d-none');
      $uploads.removeClass('d-none');
    }
  });
  $('body').on('change', '.js-filter-landing-builder-components', function (e) {
    e.preventDefault();
    var $this = $(this);
    var category = $this.val();
    var $card = $('.js-general-components-lists');
    $card.find('.js-landing-builder-component-card').addClass('d-flex').removeClass('d-none');
    if (category) {
      $card.find('.js-landing-builder-component-card').removeClass('d-flex').addClass('d-none');
      $card.find(".js-landing-builder-component-item_".concat(category)).addClass('d-flex').removeClass('d-none');
    }
  });
  $('body').on('click', '.js-view-landing-component', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-path');
    var title = $this.attr('data-title');
    handleBasicModal(path, title, function (result, $body, $footer) {
      $footer.remove();
    }, '', '84rem');
  });
})(jQuery);
/******/ })()
;