<?php
/**
 * PublicEmailTestingDetails
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Emails
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Emails
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Emails\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Emails\ObjectSerializer;

/**
 * PublicEmailTestingDetails Class Doc Comment
 *
 * @category Class
 * @description AB testing related data. This property is only returned for AB type emails.
 * @package  HubSpot\Client\Marketing\Emails
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicEmailTestingDetails implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicEmailTestingDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'ab_sampling_default' => 'string',
        'ab_sample_size_default' => 'string',
        'ab_status' => 'string',
        'ab_test_percentage' => 'int',
        'hours_to_wait' => 'int',
        'test_id' => 'string',
        'ab_success_metric' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'ab_sampling_default' => null,
        'ab_sample_size_default' => null,
        'ab_status' => null,
        'ab_test_percentage' => 'int32',
        'hours_to_wait' => 'int32',
        'test_id' => null,
        'ab_success_metric' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'ab_sampling_default' => false,
        'ab_sample_size_default' => false,
        'ab_status' => false,
        'ab_test_percentage' => false,
        'hours_to_wait' => false,
        'test_id' => false,
        'ab_success_metric' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'ab_sampling_default' => 'abSamplingDefault',
        'ab_sample_size_default' => 'abSampleSizeDefault',
        'ab_status' => 'abStatus',
        'ab_test_percentage' => 'abTestPercentage',
        'hours_to_wait' => 'hoursToWait',
        'test_id' => 'testId',
        'ab_success_metric' => 'abSuccessMetric'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'ab_sampling_default' => 'setAbSamplingDefault',
        'ab_sample_size_default' => 'setAbSampleSizeDefault',
        'ab_status' => 'setAbStatus',
        'ab_test_percentage' => 'setAbTestPercentage',
        'hours_to_wait' => 'setHoursToWait',
        'test_id' => 'setTestId',
        'ab_success_metric' => 'setAbSuccessMetric'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'ab_sampling_default' => 'getAbSamplingDefault',
        'ab_sample_size_default' => 'getAbSampleSizeDefault',
        'ab_status' => 'getAbStatus',
        'ab_test_percentage' => 'getAbTestPercentage',
        'hours_to_wait' => 'getHoursToWait',
        'test_id' => 'getTestId',
        'ab_success_metric' => 'getAbSuccessMetric'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const AB_SAMPLING_DEFAULT_MASTER = 'master';
    public const AB_SAMPLING_DEFAULT_VARIANT = 'variant';
    public const AB_SAMPLING_DEFAULT_LOSER_VARIANT = 'loser_variant';
    public const AB_SAMPLING_DEFAULT_MAB_MASTER = 'mab_master';
    public const AB_SAMPLING_DEFAULT_MAB_VARIANT = 'mab_variant';
    public const AB_SAMPLING_DEFAULT_AUTOMATED_MASTER = 'automated_master';
    public const AB_SAMPLING_DEFAULT_AUTOMATED_VARIANT = 'automated_variant';
    public const AB_SAMPLING_DEFAULT_AUTOMATED_LOSER_VARIANT = 'automated_loser_variant';
    public const AB_SAMPLE_SIZE_DEFAULT_MASTER = 'master';
    public const AB_SAMPLE_SIZE_DEFAULT_VARIANT = 'variant';
    public const AB_SAMPLE_SIZE_DEFAULT_LOSER_VARIANT = 'loser_variant';
    public const AB_SAMPLE_SIZE_DEFAULT_MAB_MASTER = 'mab_master';
    public const AB_SAMPLE_SIZE_DEFAULT_MAB_VARIANT = 'mab_variant';
    public const AB_SAMPLE_SIZE_DEFAULT_AUTOMATED_MASTER = 'automated_master';
    public const AB_SAMPLE_SIZE_DEFAULT_AUTOMATED_VARIANT = 'automated_variant';
    public const AB_SAMPLE_SIZE_DEFAULT_AUTOMATED_LOSER_VARIANT = 'automated_loser_variant';
    public const AB_STATUS_MASTER = 'master';
    public const AB_STATUS_VARIANT = 'variant';
    public const AB_STATUS_LOSER_VARIANT = 'loser_variant';
    public const AB_STATUS_MAB_MASTER = 'mab_master';
    public const AB_STATUS_MAB_VARIANT = 'mab_variant';
    public const AB_STATUS_AUTOMATED_MASTER = 'automated_master';
    public const AB_STATUS_AUTOMATED_VARIANT = 'automated_variant';
    public const AB_STATUS_AUTOMATED_LOSER_VARIANT = 'automated_loser_variant';
    public const AB_SUCCESS_METRIC_CLICKS_BY_OPENS = 'CLICKS_BY_OPENS';
    public const AB_SUCCESS_METRIC_CLICKS_BY_DELIVERED = 'CLICKS_BY_DELIVERED';
    public const AB_SUCCESS_METRIC_OPENS_BY_DELIVERED = 'OPENS_BY_DELIVERED';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAbSamplingDefaultAllowableValues()
    {
        return [
            self::AB_SAMPLING_DEFAULT_MASTER,
            self::AB_SAMPLING_DEFAULT_VARIANT,
            self::AB_SAMPLING_DEFAULT_LOSER_VARIANT,
            self::AB_SAMPLING_DEFAULT_MAB_MASTER,
            self::AB_SAMPLING_DEFAULT_MAB_VARIANT,
            self::AB_SAMPLING_DEFAULT_AUTOMATED_MASTER,
            self::AB_SAMPLING_DEFAULT_AUTOMATED_VARIANT,
            self::AB_SAMPLING_DEFAULT_AUTOMATED_LOSER_VARIANT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAbSampleSizeDefaultAllowableValues()
    {
        return [
            self::AB_SAMPLE_SIZE_DEFAULT_MASTER,
            self::AB_SAMPLE_SIZE_DEFAULT_VARIANT,
            self::AB_SAMPLE_SIZE_DEFAULT_LOSER_VARIANT,
            self::AB_SAMPLE_SIZE_DEFAULT_MAB_MASTER,
            self::AB_SAMPLE_SIZE_DEFAULT_MAB_VARIANT,
            self::AB_SAMPLE_SIZE_DEFAULT_AUTOMATED_MASTER,
            self::AB_SAMPLE_SIZE_DEFAULT_AUTOMATED_VARIANT,
            self::AB_SAMPLE_SIZE_DEFAULT_AUTOMATED_LOSER_VARIANT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAbStatusAllowableValues()
    {
        return [
            self::AB_STATUS_MASTER,
            self::AB_STATUS_VARIANT,
            self::AB_STATUS_LOSER_VARIANT,
            self::AB_STATUS_MAB_MASTER,
            self::AB_STATUS_MAB_VARIANT,
            self::AB_STATUS_AUTOMATED_MASTER,
            self::AB_STATUS_AUTOMATED_VARIANT,
            self::AB_STATUS_AUTOMATED_LOSER_VARIANT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAbSuccessMetricAllowableValues()
    {
        return [
            self::AB_SUCCESS_METRIC_CLICKS_BY_OPENS,
            self::AB_SUCCESS_METRIC_CLICKS_BY_DELIVERED,
            self::AB_SUCCESS_METRIC_OPENS_BY_DELIVERED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('ab_sampling_default', $data ?? [], null);
        $this->setIfExists('ab_sample_size_default', $data ?? [], null);
        $this->setIfExists('ab_status', $data ?? [], null);
        $this->setIfExists('ab_test_percentage', $data ?? [], null);
        $this->setIfExists('hours_to_wait', $data ?? [], null);
        $this->setIfExists('test_id', $data ?? [], null);
        $this->setIfExists('ab_success_metric', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAbSamplingDefaultAllowableValues();
        if (!is_null($this->container['ab_sampling_default']) && !in_array($this->container['ab_sampling_default'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ab_sampling_default', must be one of '%s'",
                $this->container['ab_sampling_default'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAbSampleSizeDefaultAllowableValues();
        if (!is_null($this->container['ab_sample_size_default']) && !in_array($this->container['ab_sample_size_default'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ab_sample_size_default', must be one of '%s'",
                $this->container['ab_sample_size_default'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAbStatusAllowableValues();
        if (!is_null($this->container['ab_status']) && !in_array($this->container['ab_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ab_status', must be one of '%s'",
                $this->container['ab_status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAbSuccessMetricAllowableValues();
        if (!is_null($this->container['ab_success_metric']) && !in_array($this->container['ab_success_metric'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ab_success_metric', must be one of '%s'",
                $this->container['ab_success_metric'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets ab_sampling_default
     *
     * @return string|null
     */
    public function getAbSamplingDefault()
    {
        return $this->container['ab_sampling_default'];
    }

    /**
     * Sets ab_sampling_default
     *
     * @param string|null $ab_sampling_default Version of the email that should be sent if the results are inconclusive after the test period, master or variant.
     *
     * @return self
     */
    public function setAbSamplingDefault($ab_sampling_default)
    {
        if (is_null($ab_sampling_default)) {
            throw new \InvalidArgumentException('non-nullable ab_sampling_default cannot be null');
        }
        $allowedValues = $this->getAbSamplingDefaultAllowableValues();
        if (!in_array($ab_sampling_default, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ab_sampling_default', must be one of '%s'",
                    $ab_sampling_default,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ab_sampling_default'] = $ab_sampling_default;

        return $this;
    }

    /**
     * Gets ab_sample_size_default
     *
     * @return string|null
     */
    public function getAbSampleSizeDefault()
    {
        return $this->container['ab_sample_size_default'];
    }

    /**
     * Sets ab_sample_size_default
     *
     * @param string|null $ab_sample_size_default Version of the email that should be sent if there are too few recipients to conduct an AB test.
     *
     * @return self
     */
    public function setAbSampleSizeDefault($ab_sample_size_default)
    {
        if (is_null($ab_sample_size_default)) {
            throw new \InvalidArgumentException('non-nullable ab_sample_size_default cannot be null');
        }
        $allowedValues = $this->getAbSampleSizeDefaultAllowableValues();
        if (!in_array($ab_sample_size_default, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ab_sample_size_default', must be one of '%s'",
                    $ab_sample_size_default,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ab_sample_size_default'] = $ab_sample_size_default;

        return $this;
    }

    /**
     * Gets ab_status
     *
     * @return string|null
     */
    public function getAbStatus()
    {
        return $this->container['ab_status'];
    }

    /**
     * Sets ab_status
     *
     * @param string|null $ab_status Status of the AB test.
     *
     * @return self
     */
    public function setAbStatus($ab_status)
    {
        if (is_null($ab_status)) {
            throw new \InvalidArgumentException('non-nullable ab_status cannot be null');
        }
        $allowedValues = $this->getAbStatusAllowableValues();
        if (!in_array($ab_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ab_status', must be one of '%s'",
                    $ab_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ab_status'] = $ab_status;

        return $this;
    }

    /**
     * Gets ab_test_percentage
     *
     * @return int|null
     */
    public function getAbTestPercentage()
    {
        return $this->container['ab_test_percentage'];
    }

    /**
     * Sets ab_test_percentage
     *
     * @param int|null $ab_test_percentage The size of your test group.
     *
     * @return self
     */
    public function setAbTestPercentage($ab_test_percentage)
    {
        if (is_null($ab_test_percentage)) {
            throw new \InvalidArgumentException('non-nullable ab_test_percentage cannot be null');
        }
        $this->container['ab_test_percentage'] = $ab_test_percentage;

        return $this;
    }

    /**
     * Gets hours_to_wait
     *
     * @return int|null
     */
    public function getHoursToWait()
    {
        return $this->container['hours_to_wait'];
    }

    /**
     * Sets hours_to_wait
     *
     * @param int|null $hours_to_wait Time limit on gathering test results. After this time is up, the winning version will be sent to the remaining contacts.
     *
     * @return self
     */
    public function setHoursToWait($hours_to_wait)
    {
        if (is_null($hours_to_wait)) {
            throw new \InvalidArgumentException('non-nullable hours_to_wait cannot be null');
        }
        $this->container['hours_to_wait'] = $hours_to_wait;

        return $this;
    }

    /**
     * Gets test_id
     *
     * @return string|null
     */
    public function getTestId()
    {
        return $this->container['test_id'];
    }

    /**
     * Sets test_id
     *
     * @param string|null $test_id The ID of the AB test.
     *
     * @return self
     */
    public function setTestId($test_id)
    {
        if (is_null($test_id)) {
            throw new \InvalidArgumentException('non-nullable test_id cannot be null');
        }
        $this->container['test_id'] = $test_id;

        return $this;
    }

    /**
     * Gets ab_success_metric
     *
     * @return string|null
     */
    public function getAbSuccessMetric()
    {
        return $this->container['ab_success_metric'];
    }

    /**
     * Sets ab_success_metric
     *
     * @param string|null $ab_success_metric Metric to determine the version that will be sent to the remaining contacts.
     *
     * @return self
     */
    public function setAbSuccessMetric($ab_success_metric)
    {
        if (is_null($ab_success_metric)) {
            throw new \InvalidArgumentException('non-nullable ab_success_metric cannot be null');
        }
        $allowedValues = $this->getAbSuccessMetricAllowableValues();
        if (!in_array($ab_success_metric, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ab_success_metric', must be one of '%s'",
                    $ab_success_metric,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ab_success_metric'] = $ab_success_metric;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


