<?php
/**
 * FieldGroup
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Forms
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Forms
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Forms\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Forms\ObjectSerializer;

/**
 * FieldGroup Class Doc Comment
 *
 * @category Class
 * @description A collection of up to three form fields usually displayed in a row.
 * @package  HubSpot\Client\Marketing\Forms
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FieldGroup implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FieldGroup';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'group_type' => 'string',
        'rich_text_type' => 'string',
        'rich_text' => 'string',
        'fields' => '\HubSpot\Client\Marketing\Forms\Model\DependentFieldDependentField[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'group_type' => null,
        'rich_text_type' => null,
        'rich_text' => null,
        'fields' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'group_type' => false,
        'rich_text_type' => false,
        'rich_text' => false,
        'fields' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'group_type' => 'groupType',
        'rich_text_type' => 'richTextType',
        'rich_text' => 'richText',
        'fields' => 'fields'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'group_type' => 'setGroupType',
        'rich_text_type' => 'setRichTextType',
        'rich_text' => 'setRichText',
        'fields' => 'setFields'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'group_type' => 'getGroupType',
        'rich_text_type' => 'getRichTextType',
        'rich_text' => 'getRichText',
        'fields' => 'getFields'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const GROUP_TYPE_DEFAULT_GROUP = 'default_group';
    public const GROUP_TYPE_PROGRESSIVE = 'progressive';
    public const GROUP_TYPE_QUEUED = 'queued';
    public const RICH_TEXT_TYPE_TEXT = 'text';
    public const RICH_TEXT_TYPE_IMAGE = 'image';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getGroupTypeAllowableValues()
    {
        return [
            self::GROUP_TYPE_DEFAULT_GROUP,
            self::GROUP_TYPE_PROGRESSIVE,
            self::GROUP_TYPE_QUEUED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRichTextTypeAllowableValues()
    {
        return [
            self::RICH_TEXT_TYPE_TEXT,
            self::RICH_TEXT_TYPE_IMAGE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('group_type', $data ?? [], null);
        $this->setIfExists('rich_text_type', $data ?? [], null);
        $this->setIfExists('rich_text', $data ?? [], null);
        $this->setIfExists('fields', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['group_type'] === null) {
            $invalidProperties[] = "'group_type' can't be null";
        }
        $allowedValues = $this->getGroupTypeAllowableValues();
        if (!is_null($this->container['group_type']) && !in_array($this->container['group_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'group_type', must be one of '%s'",
                $this->container['group_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['rich_text_type'] === null) {
            $invalidProperties[] = "'rich_text_type' can't be null";
        }
        $allowedValues = $this->getRichTextTypeAllowableValues();
        if (!is_null($this->container['rich_text_type']) && !in_array($this->container['rich_text_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'rich_text_type', must be one of '%s'",
                $this->container['rich_text_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['fields'] === null) {
            $invalidProperties[] = "'fields' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets group_type
     *
     * @return string
     */
    public function getGroupType()
    {
        return $this->container['group_type'];
    }

    /**
     * Sets group_type
     *
     * @param string $group_type 
     *
     * @return self
     */
    public function setGroupType($group_type)
    {
        if (is_null($group_type)) {
            throw new \InvalidArgumentException('non-nullable group_type cannot be null');
        }
        $allowedValues = $this->getGroupTypeAllowableValues();
        if (!in_array($group_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'group_type', must be one of '%s'",
                    $group_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['group_type'] = $group_type;

        return $this;
    }

    /**
     * Gets rich_text_type
     *
     * @return string
     */
    public function getRichTextType()
    {
        return $this->container['rich_text_type'];
    }

    /**
     * Sets rich_text_type
     *
     * @param string $rich_text_type The type of rich text included. The default value is text.
     *
     * @return self
     */
    public function setRichTextType($rich_text_type)
    {
        if (is_null($rich_text_type)) {
            throw new \InvalidArgumentException('non-nullable rich_text_type cannot be null');
        }
        $allowedValues = $this->getRichTextTypeAllowableValues();
        if (!in_array($rich_text_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'rich_text_type', must be one of '%s'",
                    $rich_text_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['rich_text_type'] = $rich_text_type;

        return $this;
    }

    /**
     * Gets rich_text
     *
     * @return string|null
     */
    public function getRichText()
    {
        return $this->container['rich_text'];
    }

    /**
     * Sets rich_text
     *
     * @param string|null $rich_text A block of rich text or an image. Those can be used to add extra information for the customers filling in the form. If the field group includes fields, the rich text will be displayed before the fields.
     *
     * @return self
     */
    public function setRichText($rich_text)
    {
        if (is_null($rich_text)) {
            throw new \InvalidArgumentException('non-nullable rich_text cannot be null');
        }
        $this->container['rich_text'] = $rich_text;

        return $this;
    }

    /**
     * Gets fields
     *
     * @return \HubSpot\Client\Marketing\Forms\Model\DependentFieldDependentField[]
     */
    public function getFields()
    {
        return $this->container['fields'];
    }

    /**
     * Sets fields
     *
     * @param \HubSpot\Client\Marketing\Forms\Model\DependentFieldDependentField[] $fields The form fields included in the group
     *
     * @return self
     */
    public function setFields($fields)
    {
        if (is_null($fields)) {
            throw new \InvalidArgumentException('non-nullable fields cannot be null');
        }
        $this->container['fields'] = $fields;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


